function mmhtTraining = collateMMHTData(mmhtDir, detectionResultsDir)
globals;
load([detectionResultsDir 'trainingData'], 'trainingData');

posFeatures = [];
posLabels = [];
posImgIds = [];
for i = 1 : length(trainingData.pos)
  imgId = trainingData.pos(i);
  try
    load([mmhtDir sprintf('%d_', imgId) 'mmht_pos.mat'], ...
      'response', 'labels');
  catch
    continue;
  end
  if ~isempty(response)
    posFeatures = [posFeatures; response];
    posLabels = [posLabels; labels];
    posImgIds = [posImgIds; imgId * ones(size(labels))];
  end
end

negFeatures = [];
negLabels = [];
negImgIds = [];
for i = 1 : length(trainingData.neg)
  imgId = trainingData.neg(i);
  try 
    load([mmhtDir sprintf('%d_', imgId) 'mmht_neg.mat'], ...
      'response', 'labels');
  catch
    continue;
  end
  if ~isempty(response)
    negFeatures = [negFeatures; response];
    negLabels = [negLabels; labels];
    negImgIds = [negImgIds; imgId * ones(size(labels))];
  end
end

mmhtTraining.features = [posFeatures; negFeatures];
mmhtTraining.labels = [posLabels; negLabels];
mmhtTraining.imgIds = [posImgIds; negImgIds];
end
