function displayDetectionsAsDots(results, overlap, saveDir, ...
  selectedClusters, prefix)
for i = 1 : length(results)
  detections = results{i}.firstLevel.detections;
  numDet = results{i}.firstLevel.numDetections;
  boxes = zeros(numDet, 5);
  boxCl = zeros(numDet, 1);
  boxInd = 0;
  I = im2double(imread(results{i}.firstLevel.imagePath));
  for j = 1 : length(detections)
    if ~isempty(detections(j).metadata)
      met = detections(j).metadata;
      descVals = detections(j).decision;
      tmpbox = zeros(length(met), 5);
      for k = 1 : length(met)
        tmpbox(k, 1:4) = [met(k).x1 met(k).y1 met(k).x2 met(k).y2];
        tmpbox(k, 5) = descVals(k);
      end
      picks = nms(tmpbox, overlap);
      boxes(boxInd + 1 : boxInd + length(picks), :) = tmpbox(picks, :);
      boxCl(boxInd + 1 : boxInd + length(picks)) = j;
      boxInd = boxInd + length(picks);
      
      % show detections
      
%       displayBoxes(I, i, j * ones(1, length(picks)), tmpbox(picks, :), ...
%         selectedClusters, numDet, saveDir);
%       pause;
    end
  end
  boxes = boxes(1 : boxInd, :);
  boxCl = boxCl(1 : boxInd);
  
  if ~isempty(I)
    displayDots(I, i, boxCl, boxes, selectedClusters, numDet, saveDir, ...
      prefix)
  end
%   pause;
end
end

function displayDots(I, detInd, boxCl, boxes, selectedClusters,...
  numDets, saveDir, prefix)
factor = getResizeFactor(I);
I = imresize(I, factor);
boxes = boxes * factor;
fig1 = figure(1); clf;
allColors = 'ymcrgbwk';
allMarkers = '+o*.xsd^v><ph';
numColors = length(allColors);
numMarkers = length(allMarkers);
imshow(I);
hold on;
for j = 1 : size(boxes, 1)
  selCol = allColors(rem(boxCl(j), numColors) + 1);
  selMarker = allMarkers(rem(boxCl(j), numMarkers) + 1);
  px = (boxes(j, 1) + boxes(j, 3)) / 2;
  py = (boxes(j, 2) + boxes(j, 4)) / 2;
  plot(px, py, [selMarker selCol], ...
    'MarkerSize', 10, 'LineWidth', 3);
  % Select a text color
  txtColor = 'w';
  if selCol == 'w' || selCol == 'c' || selCol == 'y' || selCol == 'g'
    txtColor = 'k';
  end
%   text(px + 4, py + 4, sprintf('%d[%.3f]', ...
%     selectedClusters(boxCl(j)), boxes(j, 5)), ...
%     'BackgroundColor', selCol, ...
%     'Color', txtColor);
  text(px + 4, py + 4, sprintf('%d', ...
    selectedClusters(boxCl(j))), ...
    'BackgroundColor', selCol, ...
    'Color', txtColor);
end
frame = getframe(fig1);
imwrite(frame.cdata, [saveDir sprintf('/%s%.4d_det.jpg', prefix, detInd)]);
hold off;
end

function displayBoxes(I, detInd, boxCl, boxes, selectedClusters,...
  numDets, saveDir)
fig1 = figure(1); clf;
allColors = 'ymcrgbwk';
numColors = length(allColors);
imshow(I);
for j = 1 : size(boxes, 1)
  selCol = allColors(rem(boxCl(j), numColors) + 1);
  rectangle('Position', [boxes(j, 1) boxes(j, 2) ...
    boxes(j, 3)-boxes(j, 1) boxes(j, 4)-boxes(j, 2)], ...
    'EdgeColor', selCol, ...
    'LineWidth', 2);
end
for j = 1 : size(boxes, 1)
  selCol = allColors(rem(boxCl(j), numColors) + 1);
  txtColor = 'w';
  if selCol == 'w' || selCol == 'c' || selCol == 'y' || selCol == 'g'
    txtColor = 'k';
  end
  text(boxes(j, 1), boxes(j, 2) - 12, sprintf('%d[%.3f]', ...
    selectedClusters(boxCl(j)), boxes(j, 5)), ...
    'BackgroundColor', selCol, ...
    'Color', txtColor);
end
text(3, -5, ...
  sprintf('%d:%d', numDets, length(boxCl)), 'Color', 'r');
frame = getframe(fig1);
imwrite(frame.cdata, [saveDir sprintf('/%d_det.jpg', detInd)]);
% print(fig1, '-djpeg', '-r0', [saveDir sprintf('/%d_det.jpg', detInd)]);
end

function factor = getResizeFactor(img)
[nrows, ncols, chans] = size(img);
factor = 300 / nrows;
end