globals;

normalDataSrc = CONFIG.normalSource;

normalMaps = dir([normalDataSrc '/*.mat']);
for i=1:numel(normalMaps)
    normalMap = normalMaps(i).name;
    target = strrep(strrep(normalMap,'nm','nmvis'),'.mat','.jpg');
    if exist([normalDataSrc '/' target])
        continue;
    end
    fprintf('Visualizing normal map %d/%d\n',i,numel(normalMaps));

    %next, load the actual data
    imageNormalData = load([normalDataSrc '/' normalMap]);
    N = cat(3,imageNormalData.nx,imageNormalData.ny,imageNormalData.nz);
    Nv = imageNormalData.depthValid;
    Nvis = bsxfun(@times,uint8(128*N+128),uint8(Nv));

    imwrite(Nvis,[normalDataSrc '/' target]);
end
