globals;

dataTarget = CONFIG.processedSource;
clusterLocation = 'clusters/';
metadataLocation = 'metadata/';

minDepthAvailability = 0.8;
edgeHangDistance = 0.05;
maxEdgePatchFraction = 0.4;

scoreNames = {  'depthMaxD','depthMeanD',...
                'normalMaxD','normalMeanD'};

%'depthAvailability','minBorderDistances',...
splitClusterDirectory = [dataTarget '/' clusterLocation '/'];
splitMetadataDirectory = [dataTarget '/' metadataLocation '/'];
clusters = dir([splitClusterDirectory '/c_*']);

if ~exist(splitMetadataDirectory)
    mkdir(splitMetadataDirectory);
end

%the scores
scores = zeros(numel(scoreNames), numel(clusters));
ranks = zeros(size(scores));
valid = ones(1,numel(clusters));

%load everything in
for ci=1:numel(clusters)
    fprintf('%d / %d\n', ci, numel(clusters));
    scoreBase = [splitClusterDirectory '/' clusters(ci).name '/clusterScores/'];
    %the amount of depth data that's available
    depthAvailability = dlmread([scoreBase '/depthAvailability.txt']);
    %calculate how many patches are stuck up an edge (this is a vector)
    minBorderDistances = dlmread([scoreBase '/minBorderDistances.txt']);
    tooClose = minBorderDistances < edgeHangDistance;
    edgePatchFraction = mean(tooClose);

    %figure out whether the patch is valid
    valid(ci) = ((edgePatchFraction < maxEdgePatchFraction) + (depthAvailability>minDepthAvailability)) > 0;
    
    %load all the scores
    for scoreI=1:numel(scoreNames)
        scores(scoreI,ci) = dlmread([scoreBase '/' scoreNames{scoreI} '.txt']);
    end
end 

%compute ranks for each score and aggregate
for scoreI=1:numel(scoreNames)
    ranks(scoreI,:) = tiedrank(scores(scoreI,:));
end

rankSum = sum(ranks);
invalidIndicator = max(rankSum) + 1;
%adjust the rank-sums to push invalid clusters to the back
rankSum = rankSum + (~valid) .* invalidIndicator;

%sort the sums
[~,patchOrder] = sort(rankSum);

rankedCluster = {};
for i=1:numel(patchOrder)
    rankedCluster{i} = clusters(patchOrder(i)).name; 
end

fprintf('Dumping data\n');
%dump the data (including whether the item is valid
fh = fopen([splitMetadataDirectory '/clusterRanks.txt'],'w');
for ii=1:numel(patchOrder)
    i = patchOrder(ii);
    fprintf(fh, '%s\n', clusters(i).name);
end
fclose(fh);

dlmwrite([splitMetadataDirectory '/clusterValid.txt'], valid(patchOrder));

