globals;

batchSource = '/div2/train/';
refSource = sprintf('/%d/',CONFIG.iterCut);
detSource = sprintf('/%d/',CONFIG.iterCut);

%add the detector code path 
addpath(genpath(CONFIG.detectorCode));

splitSource = CONFIG.rawSource;
splitTarget = CONFIG.processedSource;

if ~exist(splitTarget,'file')
    mkdir(splitTarget);
end

clusterTarget = [splitTarget '/clusters/'];
detectorTarget = [splitTarget '/detectors/'];

if ~exist(clusterTarget,'file')
    mkdir(clusterTarget);
end
if ~exist(detectorTarget,'file')
    mkdir(detectorTarget); 
end

%figure out the location of all of the batches
batches = {};
batchSort = {};

splitSplitSource = [splitSource '/' batchSource];
%look for batch folders
batchesSplit = dir([splitSplitSource '/batch-*']);
for batchI=1:numel(batchesSplit)
    batchFolder = [splitSplitSource '/' batchesSplit(batchI).name '/'];
    batches = [batches, batchFolder];
    batchSort = [batchSort, batchesSplit(batchI).name];
end

[~,sortOrder] = sort(batchSort);
batches = batches(sortOrder);

fprintf('Found %d batches\n',numel(batches));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CLUSTERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%load them, and concatenate into one big matrix
patchesConcat = []; assignedClustConcat = [];
for batchI=1:numel(batches)
    fprintf('Loading batch %d\n', batchI);
    %load positivePatches, assignedClust
    load([batches{batchI} refSource '/FIG_PATCH_CLUSTERS_REF.mat']);
    patchesConcat = [patchesConcat, positivePatches];
    assignedClustConcat = [assignedClustConcat, assignedClust];
end

writeOutClusters(patchesConcat, assignedClustConcat, clusterTarget);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DETECTORS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

detectorIds = unique(assignedClustConcat);
detectorIds(detectorIds==0) = [];

fullDetectors = [];
for batchI=1:numel(batches)
    fprintf('Loading Detectors\n');
    load([batches{batchI} detSource '/detectors_MINED.mat']);
    if(batchI == 1)
        fullDetectors = detectors;
    else
        %nasty, yes, I know.
        fullDetectors.voteWeights = [fullDetectors.voteWeights, detectors.voteWeights];
        fl = fullDetectors.firstLevModels;
        dl = detectors.firstLevModels;
        fl.w = [fl.w; dl.w];
        fl.rho = [fl.rho; dl.rho];
        fl.firstLabel = [fl.firstLabel; dl.firstLabel];
        fl.info = [fl.info; dl.info];
        fl.threshold = [fl.threshold; dl.threshold];
        fullDetectors.firstLevModels = fl;
    end
end

detectors = fullDetectors;
save([detectorTarget '/detectors.mat'],'detectors','detectorIds');

