function selInds = pickCompactCluster(patches, numSelect)
    numPatches = numel(patches);

    if(numPatches <= numSelect)
        selInds = 1:numPatches;
        return;
    end

    globals;
    normalSrc = CONFIG.normals;

    patchTargetSize = [20 20];

    nxs = {}; nys = {}; nzs = {}; validImage = {};

    %load the normal patches
    for i=1:numPatches
        [~,imName,ext] = fileparts(patches(i).im);
        %nx, ny, nz, depthValid
        load([normalSrc strrep(imName, 'rgb', 'nm') '.mat']);
        nx = max(min(nx,1),-1); ny = max(min(ny,1),-1); nz = max(min(nz,1),-1);
           
        minX = patches(i).x1;
        minY = patches(i).y1; 
        maxX = patches(i).x2;
        maxY = patches(i).y2;

        pnx = nx(minY:maxY,minX:maxX);      
        pny = ny(minY:maxY,minX:maxX);      
        pnz = nz(minY:maxY,minX:maxX);      
        pValidImage = depthValid(minY:maxY,minX:maxX) > 0;
    
        %resize to canonical size

        pValidImage = imresize_old(pValidImage, patchTargetSize);
        pValidImage = pValidImage >= 1;

        pnx = imresize_old(pnx, patchTargetSize);
        pny = imresize_old(pny, patchTargetSize);
        pnz = imresize_old(pnz, patchTargetSize);

        nxs{i} = pnx(:); nys{i} = pny(:); nzs{i} = pnz(:); validImage{i} = pValidImage(:);
    end 

    sumND = [];
    patchCluster = {};

    %do the actual selection
    for i=1:numPatches
        inds = 1:numPatches;
        inds = inds(inds~=i);
        normalDistances = zeros(numel(inds,1));
        for jj=1:numel(inds)
            j=inds(jj);
            normalDist = sum(nxs{i} .* nxs{j} + nys{i} .* nys{j} + nzs{i} .* nzs{j});
            normalDistances(jj) = normalDist;
        end 
        %this is a dot product, so we want the largest ones
        [~,sortByDistance] = sort(normalDistances,'descend');
        sortByDistance = sortByDistance(1:numSelect-1);
        sumND(i) = sum(normalDistances(sortByDistance));
        patchCluster{i} = [i, inds(sortByDistance)];
    end 

    [~,minInd] = max(sumND); 

    selInds = patchCluster{minInd};

end
