function [keep, errorEval] = evaluateHNMineDetections(clustMetadata, canonical, normalData, ids, threshold)
    %evaluate whether to use a normal hard mining negative result
    %
    % N = num detectors; M = num images
    %
    % clustMetaData - from the collate function NxM (but a ragged array)
    % canonical - a Nx1 cell containing [80,80,3] patches giving the canonical form of a cluster
    % normalData - a Mx1 cell containing the normal data for the images
    % id - which image the NxMth detection corresponds to
    % threshold - ignore detections with mean angular distance less than this; this should be quite high
    %
    newMetadata = clustMetadata;
    numDetectors = size(clustMetadata,1);
    numImages = size(clustMetadata,2);
    keep = cell(numDetectors,numImages);
    errorEval = cell(numDetectors,numImages);
    for i=1:numDetectors
        fprintf('Evaluating for detector %d / %d\n', i, numDetectors);
        for j=1:numImages
            id = ids(i,j);
            keep{i,j} = zeros(1,numel(clustMetadata{i,j}));
            errorEval{i,j} = zeros(1,numel(clustMetadata{i,j}),1);
            for k=1:numel(clustMetadata{i,j})
                detection = clustMetadata{i,j}(k);
                x1 = detection.x1; x2 = detection.x2; 
                y1 = detection.y1; y2 = detection.y2;
                P = cat(3,  normalData{id}.nx(y1:y2,x1:x2), ...
                            normalData{id}.ny(y1:y2,x1:x2), ...
                            normalData{id}.nz(y1:y2,x1:x2));
                PValid = normalData{id}.depthValid(y1:y2,x1:x2);
                PError = comparePatchToGTPatch(canonical{i}, P, PValid);
                keep{i,j}(k) = PError > threshold; 
                errorEval{i,j}(k) = PError;
            end 
        end
    end 
end
