function meanValidDist = comparePatchToGTPatch(patch, gtPatch, valid)
    %computes the mean angular distance between the patch and a ground-truth patch
    %taking into consideration a validity map
        
    ph = size(patch,1); pw = size(patch,2);
    gtph = size(gtPatch,1); gtpw = size(gtPatch,2);

    if(ph < gtph)
        %then resize ground truth to match the patch
        resizedGTPatch = zeros(size(patch));
        for c=1:3
            resizedGTPatch(:,:,c) = imresize_old(gtPatch(:,:,c),[ph,pw]);
        end
        gtPatch = resizedGTPatch;
        valid = imresize_old(valid,[ph,pw]) == 1;
    else
        %then resize the patch to match ground truth
        resizedPatch = zeros(size(gtPatch));
        for c=1:3
            resizedPatch(:,:,c) = imresize_old(patch(:,:,c),[gtph,gtpw]);
        end
        patch = resizedPatch;
    end

    %normalize 
    patch = normalizePatch(patch);
    gtPatch = normalizePatch(gtPatch);

    %compute the dot product and then angle
    dpMap = sum(gtPatch .* patch, 3);
    thetaMap = acos(dpMap); 
    if sum(valid) == 0
        meanValidDist = 1e10;
    else
        meanValidDist = nanmean(thetaMap(valid));
    end
end
