function generatePatchImagesAll(outDir, canoSize, positivePatches)
% Generates images for all patches. No grouping is assumed. This is
% intended for a common store for all the views of the same set of patches.
%
% Author: saurabh.me@gmail.com (Saurabh Singh)
if ~exist(outDir, 'dir')
  mkdir(outDir);
end

pBar = createProgressBar();
for j = 1 : length(positivePatches)
  pBar(j, length(positivePatches));
  D = positivePatches(j);
  I = im2double(imread(D.im));
  if D.flip
    I(:,:,1) = fliplr(I(:,:,1));
    I(:,:,2) = fliplr(I(:,:,2));
    I(:,:,3) = fliplr(I(:,:,3));
  end
  D = clipPatchToBoundary(D);
  I = I(D.y1:D.y2, D.x1:D.x2, :);
  if isempty(I)
    disp('Empty patch found');
    keyboard;
    continue;
  end
  I1 = imresize_old(I, canoSize, 'bilinear');
  imwrite(I1, [outDir sprintf('%d.jpg', j)]);
end
disp('Done writing cluster images.');
end
