function [sumDist, detVotes] = getSumAllDistribution(spaceSize, space, ...
  votes, patches, weights)
% Gets the sum of distributions generated by the patches.
%
% Weights are the per patch weights.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

probs = zeros(spaceSize);
detVotes = getDetectionVoteLocations(patches, votes);
for i = 1 : length(patches)
  % Skip the patches for which the weight is too low.
  if weights(i) < 0.00001
    continue;
  end
  patchSpace = space;
  gmm = getMixtureForVotes(detVotes{i}, space);
  
  distrib = getDistributionInSpace(gmm, patchSpace);
  probs = probs + distrib .* weights(i);
%   keyboard;
end
sumDist = probs;
end

