function detections = doAutoClustDetectionClust(detectors, data, imgHome)

% Initialize the detection parameters.
detectionParams = struct( ...
  'selectTopN', false, ...
  'numToSelect', 5, ...
  'useDecisionThresh', true, ...
  'overlap', detectors.params.overlapThreshold);

detections = cell(1, length(data));
parfor i = 1 : length(data)
  detRes = detectPresence(data(i), ...
    detectors.models, ...
    detectors.params, ...
    imgHome, ...
    true, ...
    detectionParams);
  detections{i} = detRes;
end
end

