function detections = doAutoClustDetection(detectors, data, imgHome, ...
  outputDir)

if ~exist(outputDir, 'dir')
  mkdir(outputDir);
end

% Initialize the detection parameters.
detectionParams = struct( ...
  'selectTopN', false, ...
  'numToSelect', 5, ...
  'useDecisionThresh', true, ...
  'overlap', detectors.params.overlapThreshold);

successRatios = detectors.successRatios;
[unused, preferableClusts] = sort(successRatios, 'descend');

detections = cell(1, length(data));
for i = 1 : length(data)
  detRes = detectPresence(data(i), ...
    detectors.models, ...
    detectors.params, ...
    imgHome, ...
    true, ...
    detectionParams);
  
  I = im2double(imread(detRes.imagePath));
%   figure(100);
%   imshow(I);
%   figure(1);
  [rows cols unused] = size(I);
  sumDist = zeros(rows, cols);
  allDets = [];
  allDesc = [];
  for j = preferableClusts
    det = detRes.detections(j);
    if isempty(det.metadata)
      continue;
    end
    allDets = [allDets det.metadata];
    allDesc = [allDesc det.decision];
    detectors.selectedClusters(j)
    size(det.metadata)
    distrib = getSumLocDistNonPara(rows, cols, ...
      detectors.mixModels{j}.location , ...
      det.metadata);
    fig1 = figure(1); clf;
    imagesc(distrib);
    saveas(fig1, [outputDir sprintf('/%d_%d_gauss.jpg', i, j)], 'jpg');
%     pause;
    successWeight = 3 / (1 + exp(-detectors.successRatios(j)));
    sumDist = sumDist + successWeight * distrib;
%     imagesc(sumDist);
%     pause;
    fig1 = figure(1); clf;
    boxes = getBoxesForPedro(det.metadata, det.decision);
    showboxes(I, boxes);
    saveas(fig1, [outputDir sprintf('/%d_%d_box.jpg', i, j)], 'jpg');
  end
  
  boxes = getBoxesForPedro(allDets, allDesc);
  fig1 = figure(1); clf;
  I1 = I;
  I1(:, :, 1) = I(:, :, 1) .* (sumDist / max(max(sumDist))) * 4;
  I1(I1>1) = 1;
  showboxes(I1, boxes);
%   imshow(I1);
  saveas(fig1, [outputDir sprintf('/%d_det.jpg', i)], 'jpg');
  fig2 = figure(2); clf;
  imagesc(sumDist);
  saveas(fig2, [outputDir sprintf('/%d_sc.jpg', i)], 'jpg');
%   pause;
  close all;
%   pause;
end
end

