function space = getLocationSpaceForImg(params, data)
rows = data.annotation.imagesize.nrows;
cols = data.annotation.imagesize.ncols;

if rows < cols
  ncols = round((cols / rows) * params.imageCanonicalSize);
  nrows = params.imageCanonicalSize;
else
  nrows = round((rows / cols) * params.imageCanonicalSize);
  ncols = params.imageCanonicalSize;
end
xbins = round(ncols / params.sBins);
ybins = round(nrows / params.sBins);

space.xSpace = linspace(1, cols, xbins);
space.ySpace = linspace(1, rows, ybins);
space.scaleSpace = linspace(1, rows, 12);
space.aspectSpace = linspace(0.001, 1, 8);
space.rows = rows;
space.cols = cols;
space.imageCanonicalSize = params.imageCanonicalSize;
end
