function [sumDist, allDetVotes] = doDistributionGenForImage(votes, ...
  detResult, clusts, space, mmhtWts, logisParams)
% Does the distribution generation for a image
%
% Author: saurabh.me@gmail.com (Saurabh Singh)

sumDist = getEmptyDistribution(space);
allDetVotes = cell(1, length(clusts));
for clustInd = 1 : length(clusts)
%   tic;
  j = clusts(clustInd);
  det = detResult.detections(j);
%   det.metadata
  if isempty(det.metadata)
    continue;
  end
  successWeight = 1;
  if ~isempty(mmhtWts)
    if mmhtWts(j) > 0.00001
      successWeight = successWeight * mmhtWts(j);
    else
      % The weight is too small, no use calculating the votes.
      continue;
    end
  end
  
  % Weight the distributions by the detection scores. Assuming the lowest
  % score would be -1.
  if isempty(logisParams)
    logisPara = [];
  else
    logisPara = logisParams{j};
  end
  patchWeights = getPatchWeights(logisPara, det.decision);
  [distrib, detVotes] = getSumAllDistribution(size(sumDist), space, ...
    votes{j}, det.metadata, patchWeights);
  allDetVotes{clustInd} = detVotes;
  sumDist = (successWeight * distrib) + sumDist;
%   toc;
end
end
