function newPoints = convertBoxToLocationSpaceCoods(box)
% Converts coods in box to location space
%
% Author: saurabh.me@gmail.com (Saurabh Singh).
newPoints = [ ...
  (box(:, 1) + box(:, 3)) / 2, ...
  (box(:, 2) + box(:, 4)) / 2, ...
  abs(box(:, 4) - box(:, 2) + 1), ...
  atan(abs((box(:, 3) - box(:, 1) + 1) ./ ...
    (box(:, 4) - box(:, 2) + 1))) / (pi / 2), ...
];
if size(box, 2) > 4
  newPoints = [newPoints box(:, 5:end)];
end
end
