function [affinity, d] = getHistogramIntersectionAffinity(features)
% Affinity by normal L2 distance.

total = size(features, 1);
affinity = eye(total);
for i = 1 : total
  a = repmat(features(i, :), total - i, 1);
  b = features(i+1:total, :);
  num = sum(min(a, b), 2);
  amod = sum(a, 2);
  bmod = sum(b, 2);
  den = min(amod, bmod);
  dist = num ./ den;
  affinity(i, i+1:end) = dist';
  affinity(i+1:end, i) = dist;
end
d = affinity;
end
