function dists = getDistancesFromCenter(pts)
% Gets the distance of each point from the centroid.
%
% pts: m X d points
%
% Author: saurabh.me@gmail.com (Saurabh Singh)

meanPt = mean(pts);
diff = pts - repmat(meanPt, size(pts, 1), 1);
dists = sum(diff .* diff, 2);
end