function [cost appCost locCost numMemCost] = getClusterCost(candidates, ...
  membership, patchInfos)
% Computes the cost of a cluster
%
% Author: saurabh.me@gmail.com (Saurabh Singh)

mems = candidates(membership > 0);
feats = patchInfos.features(mems, :);
voteLocs = patchInfos.voteLocations(mems);

% Appearance costs. We want to penalize variance in appearance.
appCost = mean(getDistancesFromCenter(feats));
appCost = appCost * patchInfos.costFactors.appCostFactor;

% Voting location cost. We want to penalize variance in votings location.
[locCost, unused] = getBestDistance(voteLocs, ...
  patchInfos.locationWts);
locCost = locCost * patchInfos.costFactors.locCostFactor;

% Membership cost. We want to penalize too few members.
numMemCost = exp(-sum(membership));
numMemCost = numMemCost * patchInfos.costFactors.memCostFactor;
% Calculate the total cost
cost = appCost + locCost + numMemCost;
end
