%% Detection based clustering

detResDir = [PROCESSING_DIR 'detectionResultTrain1/'];
load([detResDir 'all_detections.mat']);
detectFeatures = constructDetectionBasedFeatures(allPos, ...
  selectedClusters);

%% Calculate the distance of each point from the other.

distMatrix = slmetric_pw(detectFeatures', detectFeatures', 'eucdist');

%% Write out ordered images.

trainData = [wPSTr wPnSTr];
rootDir = [PROCESSING_DIR 'resultImages/firstLevFeatureNearest/'];
for i = 1 : size(distMatrix, 1)
  dists = distMatrix(i, :);
  [unused, inds] = sort(dists);
  outDir = rootDir;
  imgIds = inds(1:10);
  prefix = sprintf('%d_', i);
  % Write current image
  writeSunImages(trainData(i), outDir, HOMEIMAGES, [prefix '0_'], true);
  % Writest nearest images.
  writeSunImages(trainData(imgIds), outDir, HOMEIMAGES, prefix, true);
%   imwrite(zeros(10, 10), [rootDir sprintf('%d.jpg', i)]);
end

%% Write out ordered images with detections

trainData = [wPSTr wPnSTr];
rootDir = [PROCESSING_DIR 'resultImages/firstLevFeatureNearest3/'];
mkdir(rootDir);
for i = 1 : size(distMatrix, 1)
  dists = distMatrix(i, :);
  [unused, inds] = sort(dists);
  outDir = rootDir;
  imgIds = inds(1:10);
  prefix = sprintf('%d_', i);
  
  displayDetectionsAsDots(allPos(imgIds), 0.5, outDir, ...
    selectedClusters, prefix)
  pause(0.0001);
  % Writest nearest images.
%   writeSunImages(trainData(imgIds), outDir, HOMEIMAGES, prefix, true);
%   imwrite(zeros(10, 10), [rootDir sprintf('%d.jpg', i)]);
end


%%

numClusters = 10;
[featClusts, featClustCents] = clusterPatches(numClusters, ...
  detectFeatures);

% We need the full training data.
trainData = [wPSTr wPnSTr];

%% Write out clustered images.

clustIds = unique(featClusts);
rootDir = [PROCESSING_DIR 'resultImages/clusteredImages/'];
for i = 1 : length(clustIds)
  outDir = [rootDir sprintf('%d/', i)];
  imgIds = find(featClusts == clustIds(i));
  writeSunImages(trainData(imgIds), outDir, HOMEIMAGES, true);
  imwrite(zeros(10, 10), [rootDir sprintf('%d.jpg', i)]);
end

%% Write out the ordered cluster patches

load([PROCESSING_DIR 'FIG_PATCH_CLUSTERS_REF'], 'assignedClust', ...
  'centers', 'PARAMS', 'selectedClusters', 'positivePatches', ...
  'allFeatures', 'patchIndexes');

%%
[unused, inds] = sort(mmhtWeights, 'descend');
selC = selectedClusters(inds);
outDir = [PROCESSING_DIR 'resultImages/mmhtOrderedClusters/'];
generatePatchImages(outDir, PARAMS, allFeatures, ...
  assignedClust, centers(inds, :), positivePatches, selC);

%%

detResDir = [PROCESSING_DIR 'detectionResultTrain1/'];
load([detResDir 'all_detections.mat']);
detectFeaturesPos = constructDetectionBasedFeatures(allPos, ...
  selectedClusters);
detectFeaturesNeg = constructDetectionBasedFeatures(allNeg, ...
  selectedClusters);

%% Train a svm

labels = [ones(size(detectFeaturesPos, 1), 1);  ...
  -1 * ones(size(detectFeaturesNeg, 1), 1)];
features = [detectFeaturesPos; detectFeaturesNeg];
fprintf('Training SVM ...  ');
model = mySvmTrain(labels, features, '-s 0 -t 0 -c 1');
[predictedLabels, accuracy, decision] = mySvmPredict(labels, ...
  features, model);

%%

detResDir = [PROCESSING_DIR 'detectionResultTest1/'];
load([detResDir 'all_detections.mat']);
detectFeaturesPosTest = constructDetectionBasedFeatures(allPos, ...
  selectedClusters);
detectFeaturesNegTest = constructDetectionBasedFeatures(allNeg, ...
  selectedClusters);

labelsTest = [ones(size(detectFeaturesPosTest, 1), 1);  ...
  -1 * ones(size(detectFeaturesNegTest, 1), 1)];
featuresTest = [detectFeaturesPosTest; detectFeaturesNegTest];
[predictedLabels, accuracy, decision] = mySvmPredict(labelsTest, ...
  featuresTest, model);
