function params = getParamsForCategory(category)
params = struct( ...
  'basePatchSize', [80 80], ...
  'patchSize', [80 80], ... % preferably a multiple of base patch size.
  'imageCanonicalSize', min([80 80]) * 5, ... % Using base patch size
  'patchCanonicalSize', [80 80], ...
  'maxLevels', 4, ...
  'patchScaleIntervals', 2, ...
  'scaleIntervals', 8, ...
  'sBins', 8, ...
  'levelFactor', 2, ...
  'patchOverlapThreshold', 0.6, ...
  'overlapThreshold', 0.4, ...
  'topNOverlapThresh', 0.5, ...
  'numPatchClusters', 1000, ...
  'minClusterSize', 3, ...
  'maxClusterSize', 10, ...
  'nThNeg', 10, ...
  'category', category, ...
  'svmflags', '-s 0 -t 0 -c 0.1');
end
