function bbox = getBoundingBox(objs, annotation)
% Gets the bounding box of an object.
%
% Author: saurabh.me@gmail.com (Saurabh Singh)

rows = annotation.imagesize.nrows;
cols = annotation.imagesize.ncols;
bbox = zeros(length(objs), 4);
for i = 1 : length(objs)
  [x,y] = getLMpolygon(objs(i).polygon);
  bbox(i, :) = [max(min(x), 1) max(min(y), 1) min(max(x), cols) ...
    min(max(y), rows)];
end
bbox = double(bbox);
end
