function displayComparativeLinePlot(lineData, titleStr)
lineStyles = {'-', '--', ':', '-.'};
clrStr = 'cmyrgbk';
numRows = size(lineData, 1);
for i = 1 : size(lineData, 1)
  for j = 1 : size(lineData, 2)
    pt = lineData{i, j};
    subplot(numRows, 3, 3 * (i - 1) + 1);
    axis equal;
    set(gca, 'YDir', 'Reverse');
    hold on;
    line([0 pt(1)], [0 pt(2)], 'Color', clrStr(i), ...
      'LineWidth', 4, 'LineStyle', lineStyles{j});
    subplot(numRows, 3, 3 * (i - 1) + 2);
    axis equal;
    set(gca, 'YDir', 'Reverse');
    hold on;
    line([0 pt(1)], [0 pt(3)], 'Color', clrStr(i), ...
      'LineWidth', 4, 'LineStyle', lineStyles{j});
    subplot(numRows, 3, 3 * (i - 1) + 3);
    axis equal;
    set(gca, 'YDir', 'Reverse');
    hold on;
    line([0 pt(2)], [0 pt(3)], 'Color', clrStr(i), ...
      'LineWidth', 4, 'LineStyle', lineStyles{j});
  end
end
title(titleStr);
end