addpath(genpath('./'));

fprintf('------\nVisualizing Normals\n-----\n');
%first we need to ensure that we have visualizations of all the normal maps
visualizeNormals;
fprintf('------\nDumping Data\n-----\n');
%then we dump the clusters
dumpClusters;
fprintf('------\nMaking Canonical Forms\n-----\n');
%then we precache the surface normals we'll transfer
makeMedianClusters;
fprintf('------\nScoring Clusters\n-----\n');
%we'll compute various stats about the clusters 
scoreClusters;
fprintf('------\nRanking\n-----\n');
%and generate a ranked list
rankClusters;
fprintf('------\nCaching Statistics\n-----\n');
%finally, compute statistics about the patch with 
%respect to the median
makePatchStats;
fprintf('------\nComputing a prior\n-----\n');
%finally, we'll compute a prior on the surface normals.
%this will be used when we don't have any detections
computeSplitPriors;
