function generateSparseSiftPatchImages(outDir, canoSize, imNames, frames)
% Generates images for all patches. No grouping is assumed. This is
% intended for a common store for all the views of the same set of patches.
%
% Author: saurabh.me@gmail.com (Saurabh Singh)
if ~exist(outDir, 'dir')
  mkdir(outDir);
end

[xall, yall] = myGetSiftDescriptorBox(rand(size(frames, 1), 128)', ...
  frames');
pBar = createProgressBar();
for j = 1 : length(imNames)
  pBar(j, length(imNames));
  I = im2double(imread(imNames{j}));
  [r, c, z] = size(I);
  th = frames(j, end);
  thD = th / pi * 180;
  IR = imrotate(I, thD, 'bilinear');
  [rr, cr, zr] = size(IR);

  cx = c / 2;
  cy = r / 2;
  th = -th;
  rot = [cos(th) -sin(th); sin(th) cos(th)];
  pt = [xall{j}; yall{j}];
  pt1 = pt - repmat([cx; cy], 1, size(pt, 2));
  newPt = rot * pt1;
  newPt = newPt + repmat([cr/2; rr/2], 1, size(pt, 2));
  boxes = getBoundingBoxesForPolygons({newPt(1, :)}, {newPt(2, :)});
  
  p.x1 = boxes(1);
  p.y1 = boxes(2);
  p.x2 = boxes(3);
  p.y2 = boxes(4);
  p.size.nrows = rr;
  p.size.ncols = cr;
  D = clipPatchToBoundary(p);
%   figure(1); 
%   imshow(I);
%   hold on;
%   plot(pt(1, :), pt(2, :));
%   hold off;
%   figure(2); 
%   imshow(IR);
%   hold on;
%   plot(newPt(1, :), newPt(2, :));
%   hold off;
%   keyboard;
  
  I = IR(D.y1:D.y2, D.x1:D.x2, :);
  if isempty(I)
    disp('Empty patch found');
    keyboard;
    continue;
  end
  I1 = imresize(I, canoSize, 'bilinear');
  imwrite(I1, [outDir sprintf('%d.jpg', j)]);
end
disp('Done writing cluster images.');
end
