function votes = computeVotesUsingCoccurances(selectedClusters, b, ah, ...
  levs, topN)

votes = cell(size(selectedClusters));
t = ones(size(b));
t = triu(t, 1);
fi = find(t(:));

pBar = createProgressBar();
for i = 1 : length(fi)
  pBar(i, length(fi));
  d = fi(i);
  [kl, jl] = ind2sub(size(b), d);
  corrPat = vertcat(ah{kl, jl, levs});
  if isempty(corrPat)
    continue;
  end

  if isempty(votes{kl})
    votes{kl} = zeros(size(topN{kl}.meta));
  end
  if isempty(votes{jl})
    votes{jl} = zeros(size(topN{jl}.meta));
  end
  votes{kl}(corrPat(:, 1)) = votes{kl}(corrPat(:, 1)) + 1;
  votes{jl}(corrPat(:, 2)) = votes{jl}(corrPat(:, 2)) + 1;
end
end