function freqTable = computeClusterFrequencyTable(detResDir, toHist)
results = PresenceDetectionResults(detResDir);
posFn = @(x) results.getPosResult(x);
negFn = @(x) results.getNegResult(x);
freqTable = [ ...
  getFrequencyTable(posFn, results.results.posImgs, toHist) ...
  getFrequencyTable(negFn, results.results.negImgs, toHist) ...
];
end

function freqTable = getFrequencyTable(resFn, imgSet, toHist)
freqTable = zeros(length(toHist), length(imgSet));
pBar = createProgressBar();
for i = 1 : length(imgSet)
  pBar(i, length(imgSet));
  r = resFn(imgSet(i));
  detec = r.firstLevel.detections;
  for j = 1 : length(toHist)
    freqTable(j, i) = freqTable(j, i) + length(detec(toHist(j)).metadata);
  end
end
end

