globals;

%this is set inside the code
perChunk = 500;
%where the initialization has happened
source = [CONFIG.processingDir '/' CONFIG.processingName '/'];

%the target and the base name. Chunk folders will be of the form %s/%s_%d
targetBase = CONFIG.processingDir;
targetName = CONFIG.processingName;

scriptNames = {'chunkMaster_%d.m','chunkWorker_%d.m'};

%has two things to fill in: the chunk number and 1 or 2 for master or worker 
script = 'global CHUNK_NUM;\nCHUNK_NUM = %d;\naddpath(genpath(''./''));\nNYUIter(%d);';

commonSource = [source '/div2/train/0/'];

fprintf('Loading processing info\n');
chunkData = load([commonSource '/FIG_PATCH_CLUSTERS_REF.mat']);
numClusters = size(chunkData.centers,1);
numChunks = ceil(numClusters / perChunk);

for chunkI=2:numChunks
    fprintf('Making chunk %d/%d\n',chunkI,numChunks);
    fprintf('Making paths\n');
    chunkTarget = sprintf('%s/%s_%d/',targetBase,targetName,chunkI);
    if ~exist(chunkTarget,'file')
        mkdir(chunkTarget);
    end
    
    %make the path
    appends = {'/div2/','/div2/train/','/div2/train/0/'};
    for i=1:numel(appends)
        subpath = [chunkTarget '/' appends{i}];
        if ~exist(subpath,'file')
            mkdir(subpath);
        end
    end
    chunkCommonFile = [chunkTarget '/div2/train/0/'];

    fprintf('Copying files\n');
    %copy the files needed
    files = dir(commonSource);
    for fileI=1:numel(files)
        name = files(fileI).name;
        fprintf(' %d / %d: %s\n',fileI,numel(files),name);
        fullName = [commonSource '/' name];
        if isdir(fullName);
            continue;
        end
        if ~exist([chunkCommonFile '/' name],'file')
            copyfile(fullName,chunkCommonFile);
        end
    end

    fprintf('Making flag files\n');
    %make batch flags 
    for chunkJ=1:numChunks
        if chunkI == chunkJ
            continue;
        end
        flagFile = sprintf('%s/batch_%d.flag',chunkCommonFile,chunkJ);
        fh = fopen(flagFile,'w'); fclose(fh);
    end

    fprintf('Making scripts\n');
    for scriptI=1:numel(scriptNames)
        fh = fopen(sprintf(scriptNames{scriptI},chunkI),'w');
        fprintf(fh,script,chunkI,scriptI);
        fclose(fh);
    end
end

