function allFeatures = generateHogFeatures(img, pos, numFeatEl, ...
  canonSize, sBin)
if isempty(pos)
  allFeatures = [];
  return;
end

[unused, unused, chans] = size(img);
if chans < 3
  img = repmat(img, [1 1 3]);
  fprintf('WARNING: Image has < 3 channels, replicating channels\n');
end

allFeatures = zeros(length(pos), numFeatEl);
for i = 1 : length(pos)
  D = pos(i);
  I = img;
  if D.flip
    I(:,:,1) = fliplr(I(:,:,1));
    I(:,:,2) = fliplr(I(:,:,2));
    I(:,:,3) = fliplr(I(:,:,3));
  end
  % This should be removed from here and moved to patch generations.
  D = clipPatchToBoundary(D);
  I = I(D.y1:D.y2, D.x1:D.x2, :);
  I = imresize_old(I, canonSize, 'bilinear');
  feat = features(I, sBin);
  feat = feat(:, :, 1:31);
  allFeatures(i, :) = feat(:)';
end
end

