function boxes = predictBoxesFromVotes(imgData, voteSpace)
% Predics the boxes from the votings.
%
% Author: saurabh.me (Saurabh Singh).
[peaks, scrs] = getPeaksFromDistrib(voteSpace.space, voteSpace);
peaks = [peaks scrs];
nrows = imgData.annotation.imagesize.nrows;
ncols = imgData.annotation.imagesize.ncols;
[peaks, toInclude] = correctLocationsForImageSize(peaks, nrows, ncols);
peaks = peaks(toInclude, :);
% Construct boxes.
bxs = convertLocationToBoxCoods(peaks);
bxs = [bxs peaks(:, 5)];

% NMS
picks = myNms(bxs, 0.5);
boxes = bxs(picks, :);
end
