function [posPred, negPred] = predictBoundingBoxFromClusterDetections(res, ...
  locs, nmsThresh)

posImgIds = res.getPosImgIds();
negImgIds = res.getNegImgIds();
tmpRes = res.getPosResult(posImgIds(1));
numDetectors = length(tmpRes.firstLevel.detections);


posResFn = @(x) res.getPosResult(x);
negResFn = @(x) res.getNegResult(x);
posPred = getPredictedBoxes(posResFn, posImgIds, numDetectors, locs, nmsThresh);
negPred = getPredictedBoxes(negResFn, negImgIds, numDetectors, locs, nmsThresh);
end

function pred = getPredictedBoxes(resFn, imgIds, numDetectors, locs, nmsThresh)
pred = cell(length(imgIds), numDetectors);
pBar = createProgressBar();
for i = 1 : length(imgIds)
  pBar(i, length(imgIds));
  r = resFn(imgIds(i));
  dets = r.firstLevel.detections;
  for j = 1 : length(dets)
    met = dets(j).metadata;
    dec = dets(j).decision;
    
    if nmsThresh >= 0
      picks = doNmsForImg(met, dets(j).decision, nmsThresh);
      met = met(picks);
      dec = dec(picks);
    end
    predLocs = convertRelativeToCanonicalVoteLocs(met, locs{j}(1, :), 1);
    predLocs = reshape(predLocs, [], 1);
    predDecs = cell(predLocs);
    for k = 1 : length(predLocs)
      predDecs{k} = ones(size(predLocs{k}, 1), 1) * dec(k);
    end
    predLocs = cell2mat(predLocs);
    predDecs = cell2mat(predDecs);
    predLocs = [predLocs predDecs];
    pred{i, j} = convertLocationToBoxCoods(predLocs, true);
    if ~isempty(pred{i, j})
      imSize = [met(1).size.nrows met(1).size.ncols];
      pred{i, j} = clipBoxesToBoundary(pred{i, j}, imSize);
    end
  end
end
end
