function generateTopNView(outFile, patchImgDir, clusters, assignedClust)
% Generates a view of the clusters.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

if exist('orderWeights', 'var')
  [unused, orderInds] = sort(orderWeights, 'descend');
else
  orderInds = 1 : length(selectedClusters);
end

allPos, allNeg, selectedClusters, ...
  outDir, orderWeights, canonicalSize, overlap)
%%%%

dispData = cell(length(clusters), 1);
for i = 1 : length(clusters)
  patIds = find(assignedClust==clusters(i));
  dispData{i} = cell(length(patIds), 1);
  dispData{i}{1} = sprintf('%d', clusters(i));
  offset = 1;
  for j = 1 : length(patIds)
    dispData{i}{offset + j} = sprintf( ...
      '<img src="%s%d.jpg" title="%d">', patchImgDir, patIds(j), ...
      patIds(j));
  end
end
generateHtmlPageWithTable(dispData, outFile);
end



all = [allPos allNeg];
maxToShow = 20;
for i = 1 : length(orderInds)
  [scores, imgIds, meta] = getAllClusterScores(all, orderInds(i), overlap);
  [vals, inds] = sort(scores, 'descend');
  toSelect = min(length(scores), maxToShow);
  selected = inds(1:toSelect);
  selectedMeta = meta(selected);
  
  namePrefix = sprintf('%d_%d_', i, selectedClusters(orderInds(i)));
  writeOutPatches(selectedMeta, outDir, canonicalSize, namePrefix, ...
    scores(selected))
end

