function ent = entangleDetections(scores, pyramid, levels, indexes)
% Entangles the scores according to the given pyramid.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).
  totalLevels = length(pyramid.features);
  ent.levels = cell(1, totalLevels);
  for i = 1 : totalLevels
    selIndexes = indexes(levels==i, :);
    mx = max(selIndexes);
    rows = mx(1);
    cols = mx(2);
    vals = zeros(rows, cols);
    inds = sub2ind([rows, cols], selIndexes(:, 1), selIndexes(:, 2));
    vals(inds) = scores(levels==i);
    [mrows, mcols, unused] = size(pyramid.features{i});
    rstart = round((mrows - rows) / 2);
    cstart = round((mcols - cols) / 2);
    ent.levels{i} = ones(mrows, mcols) * -1;
    ent.levels{i}(rstart:rstart+rows-1, cstart:cstart+cols-1) = vals;
  end
end
