function results = detectPresence(data, models, params, imgHome, ...
  removeFeatures, detectionParams)
sample = data;
pyra = constructFeaturePyramid(sample, params);
numDet = 0;
detections = getDetectionsForModel(models, pyra, ...
  params.patchCanonicalSize, sample, imgHome, detectionParams);
for j = 1 : length(detections)
  % Unset the features as we don't need them
  if removeFeatures
    detections(j).features = [];
  end
  numDet = numDet + length(detections(j).metadata);
end
data = data.annotation;
results = struct( ...
  'numDetections', numDet, ...
  'detections', detections, ...
  'imagePath', [imgHome data.folder '/' data.filename], ...
  'totalProcessed', detections(1).totalProcessed);
end

