function LRs = fitClusterLrForTopN(topN, assignedCats, categories, ...
  numToConsider, trainAllPos)
LRs = cell(length(topN), 1);
for i = 1 : length(topN)
  imgIds = topN{i}.imgIds;
  toSel = min(length(imgIds), numToConsider);
  imgIds = imgIds(1:toSel);
  scores = topN{i}.scores(1:toSel);
  hasCategory = zeros(size(imgIds));
  for j = 1 : length(imgIds)
    objNames = {trainAllPos(imgIds(j)).annotation.object.name};
    hasCategory(j) = ismember(categories{assignedCats(i)}, objNames);
  end
  % Add pseudo points to ensure that we always have atleast one.
  if sum(hasCategory) == numToConsider || sum(hasCategory) == 0
    disp('No positive or negative data to fit LR');
%     keyboard;
    hasCategory = [hasCategory 0];
    scores = [scores -5];
  end
  
  lambda = 0.001 * ones(2, 1);
  LRs{i} = fitLogReg(scores', hasCategory', lambda, false);
  
  xi = -10:0.01:1;
  yi = valLogReg(LRs{i}, xi');
  clf;
  plot(xi, yi, '.g');
  axis([-1 1 0 1]);
%   keyboard;
end
end
