function [model, result] = trainClusterSameOrder(feats, ...
        labs, svmFlags)
  posInds = labs > 0;
  posFeatures = feats(posInds, :);
  negFeatures = feats(~posInds, :);
  features = [posFeatures; negFeatures];
  labels = [ones(size(posFeatures, 1), 1); ...
    ones(size(negFeatures, 1), 1) * -1];

  fprintf('Training SVM ...  ');
  model = mySvmTrain(labels, features, svmFlags, false);
  result = {};
%   [predictedLabels, accuracy, decision] = mySvmPredict(labs, feats, model);
%   result = struct('predictedLabels', predictedLabels, 'accuracy', ...
%     accuracy, 'decision', decision);
  fprintf('Done\n');
end
