addpath('utils/');
addpath('normalComputation/');
depthSource = '../data/depth/';
normalTarget = '../data/normals2/';

if ~exist(normalTarget,'file')
    mkdir(normalTarget);
end

numImages = 1449;

parfor i=1:numImages
    fprintf('%d\n',i);
    source = sprintf('depth_%06d.mat',i); dst = sprintf('nm_%06d.mat',i);
    depthData = load([depthSource '/' source]);
    [nx, ny, nz, depthValid] = computeNormalsDSPre(depthData.depth);
    saveNormals([normalTarget '/' dst],'nx','ny','nz','depthValid');
end 

