% demo_all.m
% Demo script for the following operations:
%  - extract line segments
%  - estimate vanishing points
%  - compute omap
%  - generate cuboid hypotheses from omap
%  - sample room hypotheses from line segments
%
% Assumptions about the image
% 1. Manhattan, there are three mutually orthogonal vanishing points.
% 2. There is a vanishing point that is close to vertical.
% 3. Principal point is assumed to be at the center of the image, 
%    i.e., cropped images will not work.
%
% Related publications:
% David C. Lee, Abhinav Gupta, Martial Hebert, and Takeo Kanade.
%    "Estimating Spatial Layout of Rooms using Volumetric Reasoning about 
%    Objects and Surfaces." Advances in Neural Information Processing 
%    Systems 24 (NIPS) 2010.
% David C. Lee, Martial Hebert, and Takeo Kanade. "Geometric Reasoning for
%    Single Image Structure Recovery." IEEE Conference on Computer Vision 
%    and Pattern Recognition (CVPR) 2009.
% 
% 05/2011 David C. Lee (dclee@cs.cmu.edu)
%


function [vp, f] = lee_vp(img)
%%
%img = imread('uiuc261.jpg');

%%
addpath('lineseg');
addpath('vanishingpoint');
addpath('geometry');

%% Extract line segments
% Note: 'lines' are better for computing vanishing points.
%       'linesmore' are better for computing orientation maps.
if ispc % windows binary (recommended)
    [lines linesmore] = compute_lines(img);
else % peter kovesi line segment detector
    addpath('lineseg/pkline');
    lines = pkline(rgb2gray(img));
end

%% Compute vanishing point and focal length
[vp f] = compute_vp(lines, size(img));

end
