function selected = selectWithOneUntruncated(allData, indices, category)
% Selects the images with atleast one untruncated object.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

picked = false(size(indices));
for i = 1 : length(indices)
  ind = indices(i);
  [mems, unused] = ismember({allData(ind).annotation.object.name}, ...
    category);
  objs = allData(ind).annotation.object(mems);
  for j = 1 : length(objs)
    if strcmp(objs(j).crop, '0')
      picked(i) = true;
    end
  end
end
selected = indices(picked);
end
