function Ddetector = myDetectors2LMstruct(D, DetBoxes, Category)

% load the detector outputs. Build struct and table

nImgs = length(D);
for n = 1 : nImgs
  % get image size
%   [ncols nrows] = getaproximagesize(D(n).annotation);
%   ncols = D(n).annotation.imagesize.ncols;
%   nrows = D(n).annotation.imagesize.nrows;
  % loop on objects
  Ddetector(n).annotation.filename = D(n).annotation.filename;
  Ddetector(n).annotation.folder =  D(n).annotation.folder;
  Ddetector(n).annotation.imagesize = D(n).annotation.imagesize;
  
  boxClass = Category;
	det = DetBoxes{n};
  if ~isempty(det)
    nrows = Ddetector(n).annotation.imagesize.nrows;
    ncols = Ddetector(n).annotation.imagesize.ncols;
    
    boundingBox = det(:,[1 3 2 4]); % Each row is boundingBox(i,:) = [xmin xmax ymin ymax]
    boxScores = det(:, end);
    
    Ddetector(n).annotation = addDetector2LM(uint16(boundingBox), ...
			boxScores, boxClass, Ddetector(n).annotation);
  else
    Ddetector(n).annotation.object = struct('name', {});
  end
end

