function cats = TopN(adj, num, categories)
% Extracts top N cooccuring categories using the provided adjacency matrix.

adj = triu(adj);
[dum inds] = sort(adj(:), 'descend');
selTop = inds(1:num);
[top_fewr top_fewc] = ind2sub(size(adj), selTop);

cats = struct('category1', [], 'category2', [], 'count', []);
for i = 1 : length(top_fewr)
  cats(i).category1 = categories{top_fewr(i)};
  cats(i).category2 = categories{top_fewc(i)};
  cats(i).count = adj(top_fewr(i), top_fewc(i));
end
