function results = loadPedroDetectionResults(outDir, ids, category, ...
  maxToSel)
results = cell(size(ids));
for i = 1 : length(ids)
  i
  fileName = [outDir sprintf('%s_BASE_MOD_WITH_PART_%d.mat', category, ...
    ids(i))];
  load(fileName, 'boxes1Base');
  boxes = boxes1Base{1};
  if isempty(boxes)
    continue;
  end
  sc = boxes(:, 5);
  [~, inds] = sort(sc, 'descend');
  toSel = min(maxToSel, length(inds));
  results{i} = boxes(inds(1:toSel), :);
end
end
