function newPats = padPatchImages(patches, padding)
padSize = [padding padding 0];
if iscell(patches)
  newPats = cell(size(patches));
  for i = 1 : length(patches)
    newPats{i} = doPaddingForPatch(patches{i}, padSize);
  end
else
  newPats = doPaddingForPatch(patches, padSize);
end
end

function newPat = doPaddingForPatch(pat, padSize)
[row, col, z] = size(pat);
newPat = ones([row col z] + 2 .* padSize);
newPat(padSize(1) + 1 : padSize(1) + row, ...
  padSize(2) + 1 : padSize(2) + col, ...
  padSize(3) + 1 : padSize(3) + z) = pat;
end
