function [posPatch, posFeats, corrImgs, clustConfig] = ...
  getRandomPatchesFromPyramidBlackout(pos, posIds, params, clustConfig)
% Gets random patches from a set of images.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

posPatchesPerImg = cell(1, length(pos));
posFeatsPerImg = cell(1, length(pos));
totalPatches = 0;
pBar = createProgressBar();
for i = 1 : length(pos)
  pBar(i, length(pos));
  % Check if it is disabled
  imgInd = find(clustConfig.imgSet == posIds(i));
  isDisabled = clustConfig.disabledImgs(imgInd);
  if isDisabled
    continue;
  end
  [pats, feats, unused] = sampleRandomPatches(pos(i), params.imgsHome, params);
  if length(pats) < 10
    clustConfig.disabledImgs(imgInd) = true;
  end
  
  bx = getBoxesForPedro(pats);
  fileName = [clustConfig.maskDir sprintf('%d.mat', posIds(i))];
  oldBoxes = loadAndCheck(fileName, 'boxes');
  oldBoxes(:, 5) = 10000;
  numOld = size(oldBoxes, 1);
  allBoxes = [oldBoxes; bx];
  picks = myNmsPascal(allBoxes, 0.2);
  picks = picks(numOld + 1: end) - numOld;
  posPatchesPerImg{i} = pats(picks);
  posFeatsPerImg{i} = feats(picks, :);
  totalPatches = totalPatches + length(posPatchesPerImg{i});
end
fprintf('Appending all patches together ...\n');
[posFeats, posPatch, indexes] = appendPatchDataTogether(posFeatsPerImg, ...
  posPatchesPerImg, totalPatches);
corrImgs = indexes(:, 1);
fprintf('Total patches: %d\n', totalPatches);
end
