function features = constructDetectionBasedFeatures(allDets, ...
  selectedClusters)
% Constructs features for the images based on the detections.
% Features are M x d, where M is the number of images, and d are the number
% of detectors.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

features = zeros(length(allDets), length(selectedClusters));
for i = 1 : length(allDets)
  detections  = allDets{i}.firstLevel.detections;
  for j = 1 : length(detections)
    if isempty(detections(j).decision)
      features(i, j) = -1;
    else
      score = max(detections(j).decision);
      features(i, j) = min(1, score);
    end
  end
end
end
