function [ratio, posCounts, negCounts, posImgCounts, negImgCounts] = ...
  computePosNegDetRatio(results, posSet, negSet)

resultFn = @(x) results.getPosResult(x);
[posCounts, posImgCounts] = getCounts(posSet, resultFn, true);
resultFn = @(x) results.getNegResult(x);
[negCounts, negImgCounts] = getCounts(negSet, resultFn, false);
ratio = posCounts ./ (posCounts + negCounts);
end

function [counts, perImgCount] = getCounts(imgSet, resultFn, maxCount)
counts = [];
perImgCount = [];
pBar = createProgressBar();
for i = 1 : length(imgSet)
  pBar(i, length(imgSet));
  res = resultFn(imgSet(i));
  if isempty(counts)
    counts = zeros(size(res.firstLevel.detections));
    perImgCount = zeros(length(imgSet), length(res.firstLevel.detections));
  end
  thisCount = arrayfun(@(x) length(x.metadata), res.firstLevel.detections);
  % For each image count a maximum of maxCount times.
  if maxCount
    thisCount(thisCount>2) = 2;
  end
  counts = counts + thisCount;
  perImgCount(i, :) = thisCount;
end
end
