function [cropped, total] = getCroppedCount(data, category)
% Gets the count of cropped objects
%
% Author: saurabh.me@gmail.com (Saurabh Singh)
cropped = 0;
total = 0;
for i = 1 : length(data)
  obj = data(i).annotation.object;
  names = {obj.name};
  [sw, ind] = ismember(names, {category});
  sw = find(sw);
  total = total + length(sw);
  for j = 1 : length(sw)
    if obj(sw(j)).crop == '1'
      cropped = cropped + 1;
    end
  end
end
end
