function [prec, rec, ap, thAp] =  myGetPr(clsIndx, testLabs, scores, recThresh)
% clsIndx : Correct label
% testLabs: Labels assigned to each instance by algorithm.
% scores: Scores assigned to each instance by algorithm.
% recThresh: Recall threshold at which to report the thresholded AP.
out = scores;
[~,si]=sort(-out);
tp=testLabs(si)==clsIndx;
fp=testLabs(si)~=clsIndx;
fp=cumsum(fp);
tp=cumsum(tp);
rec=tp/sum((testLabs==clsIndx)>0);
prec=tp./(fp+tp);
[ap] = VOCap(rec, prec);
thAp = myVOCap(rec, prec, recThresh);
end
