function data = makeImageStruct(I)
    %David Fouhey, Abhinav Gupta, Martial Hebert
    %Data-Driven 3D Primitives For Single Image Understanding 
    %ICCV 2013
    %
    %Inference-only code
    %
    %Make an image struct for the detectors

    data = struct('annotation', []);
    
    if numel(size(I)) == 2 || size(I,3) == 1
        I = cat(3,I,I,I);
    end 
    [rows, cols, chans] = size(I);
    label = '';
    item = [];
    item.filename = 'null';
    item.folder = '';
    item.imagesize.nrows = rows;
    item.imagesize.ncols = cols;
    item.label = label;
    object = [];
    object.name = label;
    object.id = 1;
    object.crop = false;
    object.polygon.x = [ ...
    1, ...
    cols, ...
    cols, ...
    1, ...
    ];
    object.polygon.y = [ ...
    1, ...
    1, ...
    rows, ...
    rows, ...
    ];
    object.polygon.t = 1;
    object.polygon.key = 1;

    item.object = object;
    data(1).annotation = item;
    data(1).image = I;

end
