%
% Load program data
%
function cache = loadProgramData(TDPBase)
    %David Fouhey, Abhinav Gupta, Martial Hebert
    %Data-Driven 3D Primitives For Single Image Understanding 
    %ICCV 2013
    %
    %Inference-only code
    if nargin < 1
        TDPBase = getResourcePath(); 
    end
    TDPBase = [TDPBase '/Clusters/'];
    cache.detectors = loadDetectors([TDPBase '/detectors/detectors.mat']);
    cache.clusterData = loadRankedClusters([TDPBase],1.0);
    precisionVSVMScoreData = load([TDPBase '/metadata/precisionVSVM.mat']);
    cache.precisionVSVMScore = precisionVSVMScoreData.precisionVSVMScore;
    cache.weibullCalibrations = load([TDPBase '/metadata/CalibratedScores.mat']);
    cache.prior = load([TDPBase '/metadata/normalPrior.mat']);
end
