function rectifiedNormalMap = getRectified(vp, f, normalMap)
    %David Fouhey, Abhinav Gupta, Martial Hebert
    %Data-Driven 3D Primitives For Single Image Understanding 
    %ICCV 2013
    %
    %Inference-only code

    %Take vanishing points and a focal length and a normal map
    %and snap the results to the vanishing points. 

    %snap only results within this threshold; modify this if you 
    %want to snap only nearby normals
    thresh = 1e10;

    vps = {[vp(1), vp(2)],[vp(3),vp(4)],[vp(5),vp(6)]};
    vpXs = [vp(1), vp(3), vp(5)];
    N = computeNormalEstimates(vps, f, size(normalMap,2), size(normalMap,1));
    %make sure everything is with respect to an up-facing floor convention
    [~,maxY] = max(abs(N(:,2)));
    N = N * sign(N(maxY,2));

    %find the vertical one
    [~,verticalId] = max(abs(N(:,2)));
    horizIds = setdiff(1:3,verticalId);

    dirs = N;
    %make all the flips for the verticals
    horizNormals = N(horizIds,:);
    dirs = [dirs; horizNormals; -horizNormals];
    dirX = dirs(:,1); dirY = dirs(:,2); dirZ = dirs(:,3);

    %unravel the normal map
    h = size(normalMap,1); w = size(normalMap,2);
    Nx = normalMap(:,:,1); Ny = normalMap(:,:,2); Nz = normalMap(:,:,3);
    Nv = [Nx(:), Ny(:), Nz(:)];

    %make a huge matrix giving the distances between the predicted normals
    %and the vp surface normals
    dp = Nv * dirs';

    %snap only ones that are within thresh degrees of a vp
    cosDist = acos(dp);
    [minAngle, minIndex] = min(cosDist,[],2);       
    doAdjust = find(minAngle < thresh);
    indexAdjust = minIndex(doAdjust);

    %do the adjustments
    Nx(doAdjust) = dirX(indexAdjust); 
    Ny(doAdjust) = dirY(indexAdjust); 
    Nz(doAdjust) = dirZ(indexAdjust);

    %reshape the normals
    rectifiedNormalMap = zeros(size(normalMap));
    rectifiedNormalMap(:,:,1) = reshape(Nx,[h,w]);
    rectifiedNormalMap(:,:,2) = reshape(Ny,[h,w]);
    rectifiedNormalMap(:,:,3) = reshape(Nz,[h,w]);
end

